% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.violinPDFS.R
\name{plot_violinPDFs}
\alias{plot_violinPDFs}
\title{Plot the pdfs as violins}
\usage{
plot_violinPDFs(
  x,
  climate = x$parameters$climate[1],
  taxanames = x$input$taxa.name,
  col = viridis::viridis(20),
  ylim = range(x$modelling$xrange[[climate]]),
  save = FALSE,
  filename = "violinPDFs.pdf",
  width = 7.48,
  height = 5,
  as.png = FALSE,
  png.res = 300
)
}
\arguments{
\item{x}{A \code{\link{crestObj}} generated by either the \code{\link{crest.calibrate}},
\code{\link{crest.reconstruct}} or \code{\link{crest}} functions.}

\item{climate}{Climate variables to be used to generate the plot. By default
all the variables are included.}

\item{taxanames}{A list of taxa to use for the plot (default is all the
recorded taxa).}

\item{col}{A vector of colours that will be linearly interpolated to give a
unique colour to each taxon.}

\item{ylim}{The climate range to plot the pdfs on. Default is the full range
used to fit the \code{pdfs} (x$modelling$xrange)}

\item{save}{A boolean to indicate if the diagram should be saved as a pdf file.
Default is \code{FALSE}.}

\item{filename}{An absolute or relative path that indicates where the diagram
should be saved. Also used to specify the name of the file. Default:
the file is saved in the working directory under the name
\code{'violinPDFs.pdf'}.}

\item{width}{The width of the output file in inches (default 7.48in ~ 19cm).}

\item{height}{The height of the output file in inches (default 3in ~ 7.6cm
per variables).}

\item{as.png}{A boolean to indicate if the output should be saved as a png.
Default is \code{FALSE} and the figure is saved as a pdf file.}

\item{png.res}{The resolution of the png file (default 300 pixels per inch).}
}
\value{
A table with the climate tolerances of all the taxa
}
\description{
Plot the pdfs as violins
}
\examples{
\dontrun{
  data(crest_ex_pse)
  data(crest_ex_selection)
  reconstr <- crest.get_modern_data(
    pse = crest_ex_pse, taxaType = 0,
    climate = c("bio1", "bio12"),
    selectedTaxa = crest_ex_selection, dbname = "crest_example"
  )
  reconstr <- crest.calibrate(reconstr,
    geoWeighting = TRUE, climateSpaceWeighting = TRUE,
    bin_width = c(2, 20), shape = c("normal", "lognormal")
  )
}
## example using pre-saved reconstruction obtained with the previous command.
data(reconstr)
ranges <- plot_violinPDFs(reconstr, save=FALSE, ylim=c(5,35),
                taxanames=c(reconstr$inputs$taxa.name[c(2,4,5,1)], 'Taxon'),
                col=c('darkblue', 'firebrick3'))
lapply(ranges, head)

}
