% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_pdfs.R
\name{export_pdfs}
\alias{export_pdfs}
\title{Export the pdfs fitted for the different taxa.}
\usage{
export_pdfs(
  x,
  dataname = x$misc$site_info$site_name,
  climate = x$parameters$climate,
  taxa = x$inputs$taxa.name,
  loc = getwd(),
  as.csv = FALSE
)
}
\arguments{
\item{x}{The name, age or depth of the rows of df (the samples).}

\item{dataname}{The name of the site (default: \code{x$misc$site_info$site_name})}

\item{climate}{A vector of the climate variables to extract. See
\code{\link{accClimateVariables}} for the list of accepted values.}

\item{taxa}{The names of the taxa of interest. All the pdfs are saved by
default.}

\item{loc}{The path where to export the data (default: working directory)}

\item{as.csv}{Boolean to indicate if the data should be exported as csv (\code{TRUE}) or xlsx (\code{FALSE}, default)}
}
\value{
No return value, function called to export the PDFs as files.
}
\description{
Export the pdfs fitted for the different taxa.
}
\examples{
\dontrun{
  data(crest_ex)
  data(crest_ex_pse)
  data(crest_ex_selection)
  reconstr <- crest(
    df = crest_ex, pse = crest_ex_pse, taxaType = 0,
    site_info = c(7.5, 7.5),
    climate = c("bio1", "bio12"), bin_width = c(2, 20),
    shape = c("normal", "lognormal"),
    selectedTaxa = crest_ex_selection, dbname = "crest_example",
    leave_one_out = TRUE
  )
  #> Replace 'tempdir()' by the location where the sample should be saved (e.g. 'getwd()')
  export_pdfs(reconstr,
              dataname='crest_example',
              loc=tempdir()
  )
}

}
