% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert2presenceAbsence}
\alias{convert2presenceAbsence}
\title{Convert data into presence/absence data.}
\usage{
convert2presenceAbsence(df, threshold = 2, col2convert = 2:ncol(df))
}
\arguments{
\item{df}{The dataframe containing the data to convert.}

\item{threshold}{The threshold that defines presence (presence if >= threshold)}

\item{col2convert}{A vector of the columns to convert. Default is all the
columns but the first, which contains an age, a depth or a sampleID.}
}
\value{
A vector of unique taxonIDs.
}
\description{
Convert data into presence/absence data.
}
\examples{
df <- data.frame(matrix(1:25, ncol = 5))
colnames(df) <- paste(rep("col", 5), 1:5, sep = "")
convert2presenceAbsence(df, threshold = 15)
convert2presenceAbsence(df, col2convert = 3:5)
}
