% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/includeTaxa.R
\name{excludeTaxa}
\alias{excludeTaxa}
\title{Excludes the list of taxa from the reconstructions.}
\usage{
excludeTaxa(x, taxa, climate)
}
\arguments{
\item{x}{A \code{\link{crestObj}} produced by one of the \code{\link{crest}},
\code{\link{crest.get_modern_data}}, \code{\link{crest.calibrate}},
\code{\link{crest.reconstruct}} or \code{\link{loo}} functions.}

\item{taxa}{A vector of taxa to exclude.}

\item{climate}{A vector of climate variables to unlink the taxa with.}
}
\value{
Return the updated \code{\link{crestObj}}.
}
\description{
Excludes the list of taxa from the reconstructions.
}
\examples{
data(reconstr)
print(reconstr$inputs$selectedTaxa)
reconstr <- excludeTaxa(reconstr, 'Taxon3', 'bio1')
## 'Taxon3' is now excluded from the reconstruction of 'bio1'.
print(reconstr$inputs$selectedTaxa)

}
