% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_fit_pdfsp.R
\name{fit_pdfsp}
\alias{fit_pdfsp}
\title{Fit the species \code{pdfs}.}
\usage{
fit_pdfsp(climate, ccs, bin_width, shape, xrange, use_ccs = TRUE)
}
\arguments{
\item{climate}{A vector of climatic values where the species is present.}

\item{ccs}{A \code{ccs} object returned by \code{\link{calib_clim_space}}.}

\item{bin_width}{The width of the bins used to correct for unbalanced climate
state. Use values that split the studied climate gradient in
15-25 classes (e.g. 2°C for temperature variables). Default is 1.}

\item{shape}{The imposed shape of the species \code{pdfs}. We recommend using
'normal' for temperature variables and 'lognormal' for the
variables that can only take positive values, such as
precipitation or aridity. Default is 'normal' for all.}

\item{xrange}{The climate gradient upon which the \code{pdf} with be defined.}

\item{use_ccs}{Boolean to indicate if the \code{pdfsp} should be corrected by
the distribution of the modern climate space}
}
\value{
The pdf of the species.
}
\description{
Fit the species \code{pdfs}.
}
\examples{
# Creating one randomised species
climate_species <- round(stats::rnorm(50, 15, 2), 1)

# Creating one randomised climate space
climate_space <- base::sample(0:300 / 10, 4000, replace = TRUE)

ccs <- calib_clim_space(climate_space, 2)
xrange <- fit_xrange(ccs, "normal", 2)
pdfsp <- fit_pdfsp(climate_species, ccs, 2, "normal", xrange)
plot(xrange, pdfsp, type = "l")

# Testing that the area under the curve is equal to 1.
all.equal(sum(pdfsp * (xrange[2] - xrange[1])), 1)

}
