% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.R
\docType{methods}
\name{fitted}
\alias{fitted}
\alias{fitted,cpop.class-method}
\title{Extract model fitted values}
\usage{
\S4method{fitted}{cpop.class}(object)
}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{cpop}}.}
}
\value{
A data frame containing the endpoint coordinates for each line segment fitted between
the detected changepoints. The data frame also contains the gradient and intercept values
for each segment and the corresponding residual sum of squares (RSS).
}
\description{
Extracts the fitted values produced by \code{\link{cpop}}.
}
\examples{
library(cpop)

# simulate data with change in gradient
set.seed(1)
x <- (1:50/5)^2
y <- simchangeslope(x,changepoints=c(10,50),change.slope=c(0.25,-0.25),sd=1)

# determine changepoints
res <- cpop(y,x,beta=2*log(length(y)))

# calculate segments
fitted(res)

}
\references{
\insertRef{cpop-jss-article-2024}{cpop}
}
