% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polya.R
\name{polya}
\alias{polya}
\alias{polya.mdp}
\alias{polya.dirichletprocess}
\title{Polya Completion for Marginal MDP Samples}
\usage{
polya(res_mdp, epsilon = 0.01, upsilon = 0.01, nthreads = 1)

\method{polya}{mdp}(res_mdp, epsilon = 0.01, upsilon = 0.01, nthreads = 1)

\method{polya}{dirichletprocess}(res_mdp, epsilon = 0.01, upsilon = 0.01, nthreads = 1)
}
\arguments{
\item{res_mdp}{Samples from a marginal MDP model.}

\item{epsilon}{The desired maximum weight associated with the final remainder
component.}

\item{upsilon}{The portion of samples which do not meet the desired epsilon.}

\item{nthreads}{UNSTABLE: The number of parallel threads to launch with
OpenMP, not recommended due to induced instability.}
}
\value{
If \code{res_mdp} was an \code{mdpolya_result} object, returns
  another \code{mdpolya_result}object with \code{phi}, \code{eta} and
  \code{args} entries as in [mdp()]. If \code{res_mdp} was a
  \code{dirichletprocess} object, returns another \code{dirichletprocess}
  object with new components and altered weights.
}
\description{
Polya Completion for Marginal MDP Samples
}
\section{Methods (by class)}{
\itemize{
\item \code{polya(mdp)}: Polya extension to a \code{mdpolya_result} object.

\item \code{polya(dirichletprocess)}: Polya extension to a \code{dirichletprocess} object.

}}
\examples{
res_mdp <- mdp(rnorm(50), 10)
res_pol <- polya(res_mdp, nthreads = 1)
}
\references{
Moya B., Walker S. G. (2022). Uncertainty Quantification and the
 Marginal MDP Model. arXiv. DOI: \doi{10.48550/arxiv.2206.08418}
}
