% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convrat.R
\name{convrat}
\alias{convrat}
\title{Quantify convergence by the ratio of the current to maximum past phenotypic distance}
\usage{
convrat(phyl, phendata, convtips)
}
\arguments{
\item{phyl}{The phylogeny of interest in phylo format}

\item{phendata}{Phenotypic data for all tips}

\item{convtips}{A list consisting of the names of all convergent taxa}
}
\value{
C1, C2, C3, and C4
}
\description{
convrat quantifies convergence in a number of different ways.  The basic method uses 1-(dtip/dmax) or dmax/dtip, where dtip is the current phenotypic distance between taxa and dmax is the maximum phenotypic distance between the ancestors of those taxa.  This function also scales this measure in a variety of ways.
}
\details{
C1 = 1-(dtip/dmax).  C2 = dmax-dtip.  C3 is C2 scaled by the total amount of evolution that has occured in the clade descendend from the most recent common ancestor of all convergent tips.  C4 is C2 scaled by the total amount of evolution in the phylogeny.  This program assumes that all monophyletic clades composed entirely of putatively convergent taxa have been reduced to averages or representative taxa.
}
\examples{
phyl<-rtree(10)
phendata<-fastBM(phyl,nsim=2)
convtips<-c("t1","t2","t3")
answer<-convrat(phyl,phendata,convtips)
}
\references{
Paradis, E., J. Claude, and K. Strimmer (2004) APE: Analyses of phylogenetics
and evolution in R langauge. Bioinformatics, 20, 289-290.

Revell, L. J. (2012) phytools: An R package for phylogenetic comparative
biology (and other things). Methods Ecol. Evol. 3 217-223.
}

