% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/labelstonumbers.R
\name{labelstonumbers}
\alias{labelstonumbers}
\title{Converts taxon names to tip/edge numbers}
\usage{
labelstonumbers(phyl, tips)
}
\arguments{
\item{phyl}{The phylogeny of interest in phylo format}

\item{tips}{The names of the tips in question}
}
\value{
The numbers of all of the tips of interest.
}
\description{
Converts taxon names to corresponding tip/edge numbers in the phylogeny.
}
\details{
Simply reads in taxon names, determines which tip or edge number they correspond to, and returns those values
}
\examples{
phyl<-rtree(10)
nums<-labelstonumbers(phyl,c("t1","t2","t3"))
}
\references{
Paradis, E., J. Claude, and K. Strimmer (2004) APE: Analyses of phylogenetics
and evolution in R langauge. Bioinformatics, 20, 289-290.
Paradis, E. (2012) Analysis of Phylogenetics and Evolution with R (Second Edition). New York: Springer.
}

