% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneral.R
\name{plotCCC}
\alias{plotCCC}
\title{plotCCC}
\usage{
plotCCC(
  item,
  abilities,
  responses,
  weights = NULL,
  groups = NULL,
  range = c(-6, 6),
  by = 0.1,
  linetype = "bins",
  bins = 10,
  plotZero
)
}
\arguments{
\item{item}{A matrix of item parameters for a single item. Matrix should be of
the form used in \code{simplef}}

\item{abilities}{A vector of doubles  estimated person abilities.}

\item{responses}{A vector of integers giving the observed person responses to this item.}

\item{weights}{A vector of doubles of sampling weights.}

\item{groups}{A factor vector indicating groups.}

\item{range}{Lower and upper bounds to plot over (defaults to \code{c(-6, 6)}).}

\item{by}{A double. The increment to the sequence along \code{range} used to plot the model lines.}

\item{linetype}{A string. Should the empirical lines be based on "bins", or "regression". Defaults to "bins"}

\item{bins}{If \emph{linetype} is "bins", how many bins should be used to chunk the empirical lines?
defaults to 10. Ignored otherwise.}

\item{plotZero}{Should the zero category be plotted?
Defaults to \code{FALSE} when item is dichotomous and \code{TRUE} otherwise.}
}
\value{
A ggplot2 object.
}
\description{
Creates a plot of an item characteristic curve (by response category).
For a dichotomous item, this will yield a single curve, for polytomous items this
will produce a curve for each response category.
Note this is not for use with \code{rout} files. See the generic function \code{plotRout} for plotting rout files.
}
\examples{
myRout <- ConQuestRout()
myPlot <- plotRout(myRout)
\dontrun{
# if you run the above example you will have an ICC plot in the object `myPlot`.
plot(myPlot)
}
}
