% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{simplep}
\alias{simplep}
\title{simplep}
\usage{
simplep(theta, params)
}
\arguments{
\item{theta}{a scalar value of theta.}

\item{params}{an item design matrix that is of size response categories (k) by three. The three columns are:
* column one is scoring values, usually from 0 to k.
* column two is the delta dot parameter repeated k times
* column three is the tau parameter where for k = 1, tau = 0, and for k > 2, subsequent entries are deviations from delta dot.}
}
\value{
a k x 1 matrix of response probabilities evaluated at theta.
}
\description{
returns response probabilities for each reponse category of an item at a given value of theta.
}
\examples{
myTheta<- 0
myDelta<- 1.5
x<- 2
k <- 3
itemParamX<- seq(0, k-1, 1)
itemParamD<- rep(myDelta, k)
itemParamT<- c(0, -0.5, 0.5)
itemParam<- cbind(itemParamX, itemParamD, itemParamT)
colnames(itemParam)<- c("x", "d", "t")
myProbs<- simplep(myTheta, itemParam)
}
\keyword{internal}
