% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_bills_various.R
\name{sen_bills_passing}
\alias{sen_bills_passing}
\title{Downloads and tidies information on legislation that is under
consideration in the Federal Senate}
\usage{
sen_bills_passing(year = NULL, number = NULL, type = NULL,
  date = NULL, time = NULL)
}
\arguments{
\item{year}{Format YYYY. Returns legislation from this year.}

\item{number}{bill number.}

\item{type}{type of legislation.}

\item{date}{date requested, format YYYYMMDD. Returns information on
legislation on or after this time.}

\item{time}{Format hour-minute-second (HHmmSS). Returns information on
legislation on or after this time.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Downloads and tidies information on legislation that is under
consideration in the Federal Senate.
}
\examples{
\donttest{
sen_bills_passing()
# All MPVs (provisional presidential decrees) in 2001:
mpvs <- sen_bills_passing(year = "2001", type = "MPV")
# Bills from a certain date:
march01_2017 <- sen_bills_passing(date = 20170301)
}
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
