% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/savingby2d.R
\name{savingby2d}
\alias{savingby2d}
\title{Assess advantage of 2-D view over 1-D view for identifying
  extrapolation}
\usage{
savingby2d(x, y = NULL, method = "default")
}
\arguments{
\item{x}{A numeric or factor vector. Can also be a dataframe containing
\code{x} and \code{y}, if \code{y} is \code{NULL}.}

\item{y}{A numeric or factor vector.}

\item{method}{Character; criterion used to quantify bivariate relationships.
Can be \code{"default"}, a scagnostic measure, or \code{"DECR"} to use a
density estimate confidence region.}
}
\value{
A number between 0 and 1. Values near 1 imply no benefit to using a
  2-D view, whereas values near 0 imply that a 2-D view reveals structure
  hidden in the 1-D views.
}
\description{
A simple algorithm to evaluate the advantage of by taking a
  bivariate marginal view of two variables, when trying to avoid
  extrapolations, rather than two univariate marginal views.
}
\details{
If given two continuous variables, the variables are both scaled to
  mean 0 and variance 1. Then the returned value is the ratio of the area of
  the convex hull of the data to the area obtained from the product of the
  ranges of the two areas, i.e. the area of the bounding rectangle.

  If given two categorical variables, all combinations are tabulated. The
  returned value is the number of non-zero table entries divided by the total
  number of table entries.

  If given one categorical and one continuous variable, the returned value is
  the weighted mean of the range of the continuous variable within each
  category divided by the overall range of the continuous variable, where the
  weights are given by the number of observations in each level of the
  categorical variable.

  Requires package \code{scagnostics} if a scagnostics measure is specified
  in \code{method}. Requires package \code{hdrcde} if \code{"DECR"} (density
  estimate confidence region) is specified in \code{method}. These only apply
  to cases where \code{x} and \code{y} are both numeric.
}
\examples{
x <- runif(1000)
y <- runif(1000)
plot(x, y)
savingby2d(x, y)
## value near 1, no real benefit from bivariate view

x1 <- runif(1000)
y1 <- x1 + rnorm(sd = 0.3, n = 1000)
plot(x1, y1)
savingby2d(x1, y1)
## smaller value indicates that the bivariate view reveals some structure

}
\seealso{
\code{\link{similarityweight}}
}

