% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohorttools.R
\name{mkratetable}
\alias{mkratetable}
\title{Function makes rate table with confidence intervals for crude incidences (rates)}
\usage{
mkratetable(formula, data, alpha = 0.05, add.RR = FALSE,
  lowest.N = 0, ...)
}
\arguments{
\item{formula}{where Surv object is on lhs and marginal variable(s)
on rhs. Marginal variables should usually be factors}

\item{data}{data.frame to be used}

\item{alpha}{confidence level, default is 0.05}

\item{add.RR}{should rate ratio (RR) be added}

\item{lowest.N}{lowest frequency to be shown}

\item{...}{additional parameter for function survival::pyears}
}
\value{
table with columns named after marginal variables and n, event, incidence, se, exact.lower95ci
and  exact.upper95ci variables
}
\description{
Function makes rate table with confidence intervals for crude incidences (rates)
}
\note{
packages survival and epitools are utilized.
Frequencies lower than lowest.N replaced by 999999
Person-years scaled by default with 365.25
}
\examples{
library(survival)
tmp.lt1<-mkratetable(Surv(time,status)~ sex,data=lung)
tmp.lt2<-mkratetable(Surv(time,status)~ sex,data=lung,add.RR=TRUE,lowest.N=60)
}
\seealso{
\code{\link{survival}}  \code{\link{pyears}}
}
\author{
Jari Haukka \email{jari.haukka@helsinki.fi}
}
\keyword{survival}
