\name{bal.tab.CBPS}
\alias{bal.tab.CBPS}
\alias{bal.tab.CBMSM}

\title{
Balance statistics for \code{CBPS} Objects
}
\description{
Generates balance statistics for \code{CBPS} and \code{CBMSM} objects from the \pkg{CBPS} package.
}
\usage{
\method{bal.tab}{CBPS}(x, 
        stats,
        int = FALSE,
        poly = 1,
        distance = NULL,
        addl = NULL,
        data = NULL,
        continuous,
        binary,
        s.d.denom,
        thresholds = NULL,
        weights = NULL,
        cluster = NULL,
        imp = NULL,
        pairwise = TRUE,
        s.weights = NULL,
        abs = FALSE,
        subset = NULL,
        quick = TRUE,
        ...)
}

\arguments{
  \item{x}{
a \code{CBPS} or \code{CBMSM} object; the output of a call to \pkgfun{CBPS}{CBPS} or \pkgfun{CBPS}{CBMSM}.
}
  \item{stats, int, poly, data, continuous, binary, thresholds, weights, cluster, imp, pairwise, abs, subset, quick, \dots}{
see \fun{bal.tab} for details.

See below for special notes on the \code{distance}, \code{addl}, \code{s.d.denom}, and \code{s.weights} arguments.
}
The following arguments have special notes when used with \code{CBPS} or \code{CBMSM} objects:

\item{distance}{
propensity scores generated by \code{CBPS()} and \code{CBMSM()} are automatically included and named "prop.score". For \code{CBMSM} objects, each dataset in the list supplied to \code{distance} must have one row per individual, unlike the data frame in the original call to \code{CBMSM()}.
}
\item{addl}{
for \code{CBMSM} objects, each dataset in the list supplied to \code{addl} must have one row per individual, unlike the data frame in the original call to \code{CBMSM()}.
}
\item{s.d.denom}{
if not specified, \code{bal.tab()} will use "treated" if the estimand of the call to \code{CBPS()} is the ATT and "pooled" if the estimand is the ATE.
}
\item{s.weights}{
the \code{CBPS} object does not return sampling weights even if they are used; rather, the weights returned already have the sampling weights combined within them. Because some of the checks and defaults in \code{bal.tab()} rely on patterns in these weights, using sampling weights in \code{CBPS()} without specifying them in \code{bal.tab()} can lead to incorrect results. If sampling weights are used in \code{CBPS()}, it is important that they are specified in \code{bal.tab()} as well using the \code{s.weights} argument.
}
}
\details{
\code{bal.tab.CBPS()} and \code{bal.tab.CBMSM()} generate a list of balance summaries for the \code{CBPS} or \code{CBMSM} object given and functions similarly to \pkgfun{CBPS}{balance}.
}

\value{
For point treatments, if clusters are not specified, an object of class \code{"bal.tab"} containing balance summaries for the \code{CBPS} object. See \fun{bal.tab} for details.

If clusters are specified, an object of class \code{"bal.tab.cluster"} containing balance summaries within each cluster and a summary of balance across clusters. See \code{\link[=class-bal.tab.cluster]{bal.tab.cluster}} for details.

If \code{CBPS()} is used with multi-category treatments, an object of class \code{"bal.tab.multi"} containing balance summaries for each pairwise treatment comparison and a summary of balance across pairwise comparisons. See \code{\link[=class-bal.tab.multi]{bal.tab.multi}} for details.

If \code{CBMSM()} is used for longitudinal treatments, an object of class \code{"bal.tab.msm"} containing balance summaries for each time period and a summary of balance across time periods. See \code{\link[=class-bal.tab.msm]{bal.tab.msm}} for details.
}

\author{
Noah Greifer 
}

\seealso{
\fun{bal.tab} for details of calculations.
\code{\link[=class-bal.tab.cluster]{bal.tab.cluster}} for more information on clustered data.
\code{\link[=class-bal.tab.multi]{bal.tab.multi}} for more information on multi-category treatments.
\code{\link[=class-bal.tab.msm]{bal.tab.msm}} for more information on longitudinal treatments.
}
\examples{\dontshow{if (requireNamespace("CBPS", quietly = TRUE)) force(\{ # examplesIf}
library(CBPS)
data("lalonde", package = "cobalt")

## Using CBPS() for generating covariate balancing 
## propensity score weights
cbps.out <- CBPS(treat ~ age + educ + married + race +
             nodegree + re74 + re75, data = lalonde)
             
bal.tab(cbps.out)
\dontshow{\}) # examplesIf}}
\keyword{tables}
