% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_popgenome.R
\name{as.segsites.GENOME}
\alias{as.segsites.GENOME}
\title{Convert PopGenome Data into Coala's Format}
\usage{
\method{as.segsites}{GENOME}(data, only_synonymous = FALSE, ...)
}
\arguments{
\item{data}{The \code{GENOME} data from \pkg{PopGenome}.}

\item{only_synonymous}{Only import synonymous SNPs if set to \code{TRUE}.
This requires that \pkg{PopGenome} knows where coding regions are., e.g.
by using gff files.}

\item{...}{Ignored.}
}
\description{
Using this function, you can convert genetic data imported with the package
\pkg{PopGenome} into coala's segsites format. See \code{\link{as.segsites}}
for general information on converting genetic data for coala.
}
\details{
This function imports all loci from the \code{GENOME} object that have at
least one valid site (\code{data@n.valid.sites}). The number of valid sites
is used as length of a locus.
}
\seealso{
An example and additional instructions are provided in the
         `coala-data-import` vignette
}

