% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_plot_time_series_compare.R
\name{render_plot_time_series_compare}
\alias{render_plot_time_series_compare}
\title{Plotting routine designed for the CM SAF R Toolbox.}
\usage{
render_plot_time_series_compare(
  outfile = NULL,
  fileExtension = ".png",
  visualizeVariables,
  ticknumber,
  dateformat,
  sliderx,
  slidery,
  checkGroup_type,
  imagewidth,
  imageheight,
  text1_1d,
  text2_1d,
  textsize,
  linesize,
  col,
  legend_label1,
  legend_label2,
  station_number
)
}
\arguments{
\item{outfile}{Name of the outfile (NULL or character). Should match the fileExtension.
If NULL is passed a file is created in the R session temporary directory.}

\item{fileExtension}{The file extension of the image (character). Has to be one of the following: 'png', 'jpg', 'tif', 'kml', 'pdf'.}

\item{visualizeVariables}{A data frame containing all meta data for the plotting process (data.frame).}

\item{ticknumber}{Number of ticks (numeric).}

\item{dateformat}{Date format for constructing a date label.}

\item{sliderx}{Limiting the time series with a two valued vector for min and max (numeric).}

\item{slidery}{Limiting the y axis with a two valued vector for min and max (numeric).}

\item{checkGroup_type}{An integer between 1 and 5 indicating group type (numeric).
1 for Line, 2 for Points, 3 for Line and Points, 4 for steps, 5 for histogram.}

\item{imagewidth}{Width of the image (numeric).}

\item{imageheight}{Height of the image (numeric).}

\item{text1_1d}{Title text (character).}

\item{text2_1d}{Text to be passed to graphics::mtext (character).}

\item{textsize}{Textsize to be used (cex).}

\item{linesize}{Line width to be used (positive numeric).}

\item{col}{A color chosen via colourpicker::colourInput.}

\item{legend_label1}{Legend label of the first data set}

\item{legend_label2}{Legend label of the second data set}

\item{station_number}{For station data compare; which station is selected}
}
\description{
This function provides a time series comparison of two data sets.
}
