% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secant.R
\name{secant}
\alias{secant}
\title{Secant Method}
\usage{
secant(f, x, tol = 0.001, m = 100)
}
\arguments{
\item{f}{function to integrate}

\item{x}{an initial estimate of the root}

\item{tol}{the error tolerance}

\item{m}{the maximum number of iterations}
}
\value{
the real root found
}
\description{
The secant method for root finding
}
\details{
The secant method for root finding extends Newton's method to
estimate the derivative.  It will return when the interval between
them is less than \code{tol}, the error tolerance.  However, this
implementation also stop if after \code{m} iterations.
}
\examples{
f <- function(x) { x^3 - 2 * x^2 - 159 * x - 540 }
secant(f, 1)

}
\seealso{
Other optimz: \code{\link{bisection}},
  \code{\link{goldsect}}, \code{\link{gradient}},
  \code{\link{hillclimbing}}, \code{\link{newton}},
  \code{\link{sa}}
}
\concept{optimz}
