% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulEvalDRM.R
\name{simulEvalDRM}
\alias{simulEvalDRM}
\title{simulation-based evalutation of a dose-response model}
\usage{
simulEvalDRM(pilotData, doseLevels, numReplications, numSim,
  standardDeviation, EDp = 0.5, funcList = c("linear", "linlog",
  "exponential", "emax", "sigEmax", "logistic", "betaMod", "quadratic"))
}
\arguments{
\item{pilotData}{a dataset presenting dose-response data from a pilot study. The first column should give the doses 
and the second one should give the response values.}

\item{doseLevels}{the dose levels which should be used in the simulation study.}

\item{numReplications}{number of replications for each of thes dose levels for the simulated data.}

\item{numSim}{number of times that the simulation study should be replicated.}

\item{standardDeviation}{standard deviation of the generated response.}

\item{EDp}{scalar in (0,1), indicatign with EDp should be computed to compare different models, default is 0.5 (ED50).}

\item{funcList}{string vector with models for data generation and fitting, should be selected from 
c("linear", "linlog", "exponential", "emax", "sigEmax", "logistic", "betaMod","quadratic").}
}
\value{
a list with the following elements

estEDp a list of length of funcList providing the estimated EDp from models fitted to data generated from each model in funcList
realEDp a vector of length funcList, the EDp's computed based on the estimated parameters from different models fitted to pilotData 
bestModel a list of length funcList, a frequency table of best selected model for data generated from each model in funcList
meanEDp a matrix showing mean of estimated EDp's averaged over numSim replications.
biasEDp a matrix showing bias of estimated EDp's averaged over numSim replications.
mseEDp a matrix showing MSE of estimated EDp's averaged over numSim replications.
varEDp a matrix showing variance of estimated EDp's averaged over numSim replications.
relativeBiasEDp a matrix showing relative bias of estimated EDp's averaged over numSim replications.
absBiasEDp a matrix showing absolute bias of estimated EDp's averaged over numSim replications.
absRelativeBiasEDp a matrix showing absolute bias of estimated EDp's averaged over numSim replications.
averagaedAIC a matrix showing AIC's of different models averaged over numSim replications. 
quantity2Plot which if needed will be passed to plot method.

The output of simulEvalDRM can be passed to the function plotSimulDRM
to plot a heatmap for the desired the quantity of interest. Possible quantities
are ("mean", "bias", "mse", "variance", "relativeBias", 
			"absBias", "absRelativeBias")
}
\description{
a function to simulate data based different dose-response model using parameters estimated from a provided pilot study. 
The function then simulate data from the estimated model for the given dose levels and number of replications per dose.
Some criteria will be compauted which then can be used to compare different settings.
}
\examples{
## gnerating data, a sample of size 20
set.seed(11)
doses2Use <-  c(0, 5, 20)
numRep2Use <- c(3, 3, 3)
generatedData <- cbind(rep(1,sum(numRep2Use)),
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), doses2Use,
 numRep2Use, 1), 
		matrix(rnorm(1*sum(numRep2Use)), sum(numRep2Use), 1))
colnames(generatedData) <- c("ID", "dose", "response", "x1")
for (iGen in 2:20){
genData0 <- cbind(rep(iGen,sum(numRep2Use)), 
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), doses2Use, 
numRep2Use, 1), 
			matrix(rnorm(1*sum(numRep2Use)), sum(numRep2Use), 1))
	colnames(genData0) <- c("ID", "dose", "response", "x1")
	generatedData <- rbind(generatedData, genData0)
}
simRes <- simulEvalDRM (pilotData = 
generatedData[generatedData$ID == 2, c(2,3)], 
doseLevels = c(0, 4, 20), 
		numReplications = c(6, 3, 3), numSim = 10, 
standardDeviation = 1, EDp = 0.5,
		funcList = c("linlog", "emax", "sigEmax", "logistic"))

}
\author{
Vahid Nassiri and Yimer Wasihun.
}
