/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryCallable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryInterceptorBase;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryPolicy;
import java.util.Date;
import java.util.concurrent.CancellationException;

public class RetryInterceptorVoid
extends RetryInterceptorBase {
    public RetryInterceptorVoid(RetryCallable retryCallable, RetryPolicy retryPolicy) {
        super(retryCallable, retryPolicy);
    }

    public Object execute() throws Throwable {
        WorkflowClock clock = this.contextProvider.getDecisionContext().getWorkflowClock();
        this.scheduleWithRetry(null, 1, clock.currentTimeMillis(), 0L, clock);
        return null;
    }

    private void scheduleWithRetry(Throwable failure, final int attempt, final long firstAttemptTime, long timeOfRecordedFailure, final WorkflowClock clock) throws Throwable {
        long delay = -1L;
        if (attempt > 1) {
            if (!this.retryPolicy.isRetryable(failure)) {
                throw failure;
            }
            delay = this.retryPolicy.nextRetryDelaySeconds(new Date(firstAttemptTime), new Date(timeOfRecordedFailure), attempt);
            if (delay < 0L) {
                throw failure;
            }
        }
        if (delay > 0L) {
            Promise<Void> timer = clock.createTimer(delay);
            new Task(new Promise[]{timer}){

                protected void doExecute() throws Throwable {
                    RetryInterceptorVoid.this.invoke(attempt, firstAttemptTime, clock);
                }
            };
        } else {
            this.invoke(attempt, firstAttemptTime, clock);
        }
    }

    private void invoke(final int attempt, final long firstAttemptTime, final WorkflowClock clock) {
        final Settable shouldRetry = new Settable();
        new TryCatchFinally(){
            Throwable failureToRetry = null;

            protected void doTry() throws Throwable {
                RetryInterceptorVoid.this.retryCallable.call();
            }

            protected void doCatch(Throwable failure) throws Throwable {
                if (failure instanceof Error || failure instanceof CancellationException) {
                    throw failure;
                }
                this.failureToRetry = failure;
            }

            protected void doFinally() throws Throwable {
                shouldRetry.set(this.failureToRetry);
            }
        };
        new Task(new Promise[]{shouldRetry}){

            protected void doExecute() throws Throwable {
                Throwable failure = (Throwable)shouldRetry.get();
                if (failure != null) {
                    RetryInterceptorVoid.this.scheduleWithRetry((Exception)failure, attempt + 1, firstAttemptTime, clock.currentTimeMillis(), clock);
                }
            }
        };
    }
}

