% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotweights.R
\name{plotweights}
\alias{plotweights}
\title{Plot distribution of model weights}
\usage{
plotweights(dataset, cw1 = 0.95, cw2 = 0.5, cw3 = 0.25, arrow = FALSE,
  plotall = FALSE, plotallenv, ThreeD = FALSE)
}
\arguments{
\item{dataset}{A dataframe containing information on all fitted climate 
windows. Output from \code{\link{slidingwin}}.}

\item{cw1, cw2, cw3}{Cumulative weight levels used to visualise model weight 
distribution. Cumulative weights represent the chance that the best model is
contained within a set. For example, there is a 95 percent chance that the best
climate window model is contained within the cumulative weight level of
0.95. Parameter values must <= 1.}

\item{arrow}{TRUE or FALSE. Add arrows to plots to pinpoint best window.}

\item{plotall}{Used in conjunction with function \code{\link{plotall}}. 
Should not be changed manually.}

\item{plotallenv}{Used in conjunction with function \code{\link{plotall}}.
Should not be changed manually.}

\item{ThreeD}{TRUE or FALSE. Generate a 3-dimensional plot of the model weight landscape.}
}
\value{
Returns a plot showing the distribution of cumulative model
 weights. Levels determined by parameters cw1,cw2 and cw3.
}
\description{
Create a plot showing the distribution of cumulative model weights for
all fitted climate windows.
}
\examples{
# Plot distribution of model weights for Mass dataset

data(MassOutput)

plotweights(dataset = MassOutput, cw1 = 0.95, cw2 = 0.75, cw3 = 0.25)
}
\author{
Liam D. Bailey and Martijn van de Pol
}

