% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_numeric_to_date.R
\name{convert_numeric_to_date}
\alias{convert_numeric_to_date}
\title{Convert numeric to date}
\usage{
convert_numeric_to_date(data, target_columns, ref_date, forward = TRUE)
}
\arguments{
\item{data}{The input data frame or linelist}

\item{target_columns}{A vector of columns names to be converted from numeric
to date. When the input data is a \code{linelist} object, this parameter can be
set to \code{linelist_tags} if you wish to only convert the tagged columns.}

\item{ref_date}{A reference date. This can also be a character string with
the name of the reference column.}

\item{forward}{A Boolean to indicate whether the counts started after the
reference date (TRUE) or not (FALSE). The default is TRUE.}
}
\value{
A data frame where the column of interest are updated
}
\description{
Convert numeric to date
}
\examples{
data <- readRDS(system.file("extdata", "test_df1.RDS", package = "cleanepi"))
data <- convert_numeric_to_date(
  data           = data,
  target_columns = "recruted_on_day",
  ref_date       = as.Date("2022-10-13"),
  forward        = TRUE
)
}
