% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clarabel.R
\name{clarabel}
\alias{clarabel}
\title{Interface to 'Clarabel', an interior point conic solver}
\usage{
clarabel(A, b, q, P = NULL, cones, control = list(), strict_cone_order = TRUE)
}
\arguments{
\item{A}{a matrix of constraint coefficients.}

\item{b}{a numeric vector giving the primal constraints}

\item{q}{a numeric vector giving the primal objective}

\item{P}{a symmetric positive semidefinite matrix, default
\code{NULL}}

\item{cones}{a named list giving the cone sizes, see \dQuote{Cone
Parameters} below for specification}

\item{control}{a list giving specific control parameters to use in
place of default values, with an empty list indicating the
default control parameters. Specified parameters should be
correctly named and typed to avoid Rust system panics as no
sanitization is done for efficiency reasons}

\item{strict_cone_order}{a logical flag, default \code{TRUE} for forcing
order of cones described below. If \code{FALSE} cones can be specified
in any order and even repeated and directly passed to the solver
without type and length checks}
}
\value{
named list of solution vectors x, y, s and information
about run
}
\description{
Clarabel solves linear programs (LPs), quadratic programs (QPs),
second-order cone programs (SOCPs) and semidefinite programs
(SDPs). It also solves problems with exponential and power cone
constraints. The specific problem solved is:

Minimize \deqn{\frac{1}{2}x^TPx + q^Tx} subject to \deqn{Ax + s =
  b} \deqn{s \in K} where \eqn{x \in R^n}, \eqn{s \in R^m}, \eqn{P
  = P^T} and nonnegative-definite, \eqn{q \in R^n}, \eqn{A \in
  R^{m\times n}}, and \eqn{b \in R^m}. The set \eqn{K} is a
composition of convex cones.
}
\details{
The order of the rows in matrix \eqn{A} has to correspond to the
order given in the table \dQuote{Cone Parameters}, which means
means rows corresponding to \emph{primal zero cones} should be
first, rows corresponding to \emph{non-negative cones} second,
rows corresponding to \emph{second-order cone} third, rows
corresponding to \emph{positive semidefinite cones} fourth, rows
corresponding to \emph{exponential cones} fifth and rows
corresponding to \emph{power cones} at last.

When the parameter \code{strict_cone_order} is \code{FALSE}, one can specify
the cones in any order and even repeat them in the order they
appear in the \code{A} matrix. See below.

\subsection{Clarabel can solve}{ \enumerate{ \item linear programs
(LPs) \item second-order cone programs (SOCPs) \item exponential
cone programs (ECPs) \item power cone programs (PCPs) \item
problems with any combination of cones, defined by the parameters
listed in \dQuote{Cone Parameters} below } }

\subsection{Cone Parameters}{
The table below shows the cone parameter specifications
\tabular{rllll}{
\tab \bold{Parameter} \tab \bold{Type} \tab \bold{Length} \tab \bold{Description}                       \cr
\tab \code{z}         \tab integer     \tab \eqn{1}       \tab number of primal zero cones (dual free cones),       \cr
\tab                  \tab             \tab               \tab which corresponds to the primal equality constraints \cr
\tab \code{l}         \tab integer     \tab \eqn{1}       \tab number of linear cones (non-negative cones)          \cr
\tab \code{q}         \tab integer     \tab \eqn{\geq1}   \tab vector of second-order cone sizes                    \cr
\tab \code{s}         \tab integer     \tab \eqn{\geq1}   \tab vector of positive semidefinite cone sizes           \cr
\tab \code{ep}        \tab integer     \tab \eqn{1}       \tab number of primal exponential cones                   \cr
\tab \code{p}         \tab numeric     \tab \eqn{\geq1}   \tab vector of primal power cone parameters
} }

When the parameter \code{strict_cone_order} is \code{FALSE}, one can specify
the cones in the order they appear in the \code{A} matrix. The \code{cones}
argument in such a case should be a named list with names matching
\verb{^z*} indicating primal zero cones, \verb{^l*} indicating linear cones,
and so on. For example, either of the following would be valid: \code{list(z = 2L, l = 2L, q = 2L, z = 3L, q = 3L)}, or, \code{list(z1 = 2L, l1 = 2L, q1 = 2L, zb = 3L, qx = 3L)}, indicating a zero
cone of size 2, followed by a linear cone of size 2, followed by a second-order
cone of size 2, followed by a zero cone of size 3, and finally a second-order
cone of size 3.
}
\examples{
A <- matrix(c(1, 1), ncol = 1)
b <- c(1, 1)
obj <- 1
cone <- list(z = 2L)
control <- clarabel_control(tol_gap_rel = 1e-7, tol_gap_abs = 1e-7, max_iter = 100)
clarabel(A = A, b = b, q = obj, cones = cone, control = control)

}
\seealso{
\code{\link[=clarabel_control]{clarabel_control()}}
}
