% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histograms.R
\name{add_histogram}
\alias{add_histogram}
\title{Add a histogram plot to a chronicle report}
\usage{
add_histogram(
  report = "",
  dt,
  value,
  groups = NULL,
  binwidth = NULL,
  bins = NULL,
  scales = "fixed",
  ggtheme = NULL,
  x_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = NULL,
  histogram_title = NULL,
  title_level = 2,
  echo = FALSE,
  message = FALSE,
  warning = FALSE,
  fig_width = NULL,
  fig_height = NULL
)
}
\arguments{
\item{report}{Character string containing the text of an Rmarkdown report header (and possibly more chunks). Easily create one with chronicle::new_report(), and if NULL, that will be the default value.}

\item{dt}{data.frame containing the data to plot.}

\item{value}{Name of the column to use as values on the y axis of the plot.}

\item{groups}{Name of the column containing the different groups.}

\item{binwidth}{Width of the histogram bins.}

\item{bins}{Number of bins. Overridden by binwidth. Defaults to 30.}

\item{scales}{From ggplot2::facet_wrap: Should scales be 'fixed', 'free', or free in one dimension ('free_x', 'free_y'). Default is 'fixed'.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required.}

\item{histogram_title}{Title of the histogram plot  section on the report. If NULL, chronicle will try to parse a generic title using make_title()}

\item{title_level}{Level of the section title of this plot (ie, number of # on Rmarkdown syntax.)}

\item{echo}{Whether to display the source code in the output document. Default is FALSE.}

\item{message}{Whether to preserve messages on rendering. Default is FALSE.}

\item{warning}{Whether to preserve warnings on rendering. Default is FALSE.}

\item{fig_width}{Width of the plot (in inches).}

\item{fig_height}{Height of the plot (in inches).}
}
\value{
An rmarkdown chunk as a character string, now containing a chunk for adding the histogram plot.
}
\description{
Add a histogram plot to a chronicle report
}
\examples{
html_report <- add_histogram(report = new_report(),
                             dt = iris,
                             value = 'Sepal.Length',
                             groups = 'Species')
cat(html_report)
}
