% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-named.R
\name{chk_named}
\alias{chk_named}
\alias{vld_named}
\title{Check Named}
\usage{
chk_named(x, x_name = NULL)

vld_named(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is named using

\code{!is.null(names(x))}
}
\section{Functions}{
\itemize{
\item \code{vld_named}: Validate Named
}}

\examples{
# chk_named
chk_named(c(x = 1))
try(chk_named(list(1)))
# vld_named
vld_named(c(x = 1))
vld_named(list(x = 1))
vld_named(c(x = 1)[-1])
vld_named(list(x = 1)[-1])
vld_named(1)
vld_named(list(1))
}
\seealso{
Other chk_misc: 
\code{\link{chk_match}()},
\code{\link{chk_not_any_na}()},
\code{\link{chk_not_empty}()},
\code{\link{chk_sorted}()},
\code{\link{chk_unique}()}
}
\concept{chk_misc}
