% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf2doc.R
\name{tf2doc}
\alias{tf2doc}
\title{Transform Terms and Frequencies into a Text}
\usage{
tf2doc(term, num)
}
\arguments{
\item{term}{terms that you want to rewrite into a text. A character vector is prefered, but 
matrix, list, data frame are also OK. \code{NA} in the argument will be taken as 
letters "NA" and repeated.}

\item{num}{frequencies of terms in \code{term}. A numeric vector is prefered, but 
matrix, list, data frame are also OK. Its length must be equal to that of \code{term}.
No \code{NA} is allowed.}
}
\value{
a character vector. Terms are pasted with a space.
}
\description{
This function is simply a wrapper of \code{rep}, but allows different structures of input.
For rewriting more texts in the same time, see \code{\link{m2doc}}.
}
\examples{
x <- matrix(c("coffee", "milk", "tea", "cola"), nrow = 2)
y <- factor(c(5:8))
tf2doc(x, y)
}
