% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number.R
\name{check_number}
\alias{check_number}
\title{Check Number}
\usage{
check_number(x, coerce = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce a scalar integer to a real.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if object is a number (scalar real or if \code{coerce = TRUE} scalar integer).
}
\examples{
check_number(1.0)
check_number(c(1.0, 2.0), error = FALSE)
check_number(1L, error = FALSE)
check_number(1L, coerce = TRUE, error = FALSE)
}
