% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.mv.class.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,changepoint.mv.mrc.class,ANY-method}
\title{Visualisation of data and changepoint locations.}
\usage{
\S4method{plot}{changepoint.mv.mrc.class,ANY}(x, p = MDL(x), group = FALSE,
  display.variable.names = TRUE, show = TRUE)
}
\arguments{
\item{x}{An S4 class returned by \code{\link{mrc}}.}

\item{p}{Integer value indicating the number of most recent changepoint locations to consider. The minimum value is 1 and the maximum value is the value of \code{pmax} used
in the call to \code{\link{mrc}}. Default value is the \code{p=MDL(x)} (see \code{\link{MDL}} for further details).}

\item{group}{Logical value used to indicate if the variates that share a most recent changepoint should be grouped together in the plot. Default is \code{group=FALSE}.}

\item{display.variable.names}{Logical value. If \code{display.variable.names=TRUE} then the variable names are displayed in the plot. If there are a large number of variates in the data, then it
can be useful disable variable names by setting \code{display.variable.names=FALSE}. Default is \code{display.variable.names=TRUE}.}

\item{show}{Logical value used to indicate if the plot should be displayed (the ggplot object produced by plot is always invisibly returned). Default value is \code{show=TRUE}.}
}
\value{
Invisibly returns a ggplot object.
}
\description{
Plot methods for S4 objects returned by \code{\link{mrc}}. The plot produced depends on the type of the
S4 object.

For objects produced by \code{\link{mrc}} a heatmap of the data is displayed along with the location of the univariate changepoints (yellow), most recent univariate changepoints (green),
and most recent multivariate changepoint locations (red). 

A number of arguments with default values are provided to control aspects of how the data and changepoint locations are displayed. The plot methods return a ggplot2 object which can be
modified if required.
}
\examples{
\dontrun{
# visualising most recent changepoints 
data(mrcexample)
res<-mrc(mrcexample[,1:10])
p.1<-plot(res,p=2)
p.2<-plot(res,p=5)
p.3<-plot(res,p=2,group=TRUE)
p.4<-plot(res,p=5,group=TRUE)
if(require(gridExtra))
{
  grid.arrange(p.1,p.2,p.3,p.4)
}
}
}
