% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaniprodata.R
\name{cleaniprodata}
\alias{cleaniprodata}
\title{Clean Medtronic iPro Data}
\usage{
cleaniprodata(inputdirectory,
              outputdirectory = tempdir(),
              askforinfo = FALSE,
              maxgap = 20,
              gapfill = TRUE)
}
\arguments{
\item{inputdirectory}{The directory containing raw iPro files to be
formatted.}

\item{outputdirectory}{The directory where you would like the cleaned iPro
files to be written.}

\item{askforinfo}{Defaults to FALSE. If set to TRUE, the user will need to
input subject information to the console.}

\item{maxgap}{The maximum gap (in minutes) in sensor data that will be
interpolated. Defaults to 20 minutes.}

\item{gapfill}{Defaults to TRUE. If set to FALSE, gaps in sensor data will be
kept.}
}
\value{
one formatted CSV file per file contained in inputdirectory.
}
\description{
This function cleans exported iPro data and gets it ready for analysis. It
removes the first four hours of CGM data, fills in data for gaps smaller than
maxgap, and removes the 24 hours chunk containign gaps larger than maxgap.
The exported .csv file is written to a new directory called "Cleaned CSVs."
}
\examples{
cleaniprodata(system.file("extdata", "iPro_CSVs", package = "cgmanalysis"))
}
