% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{cff_from_bibtex}
\alias{cff_from_bibtex}
\title{Previous API: Create a \code{\link{cff}} object from BibTeX entries}
\usage{
cff_from_bibtex(x, encoding = "UTF-8", ...)
}
\arguments{
\item{x}{The source that would be used for generating the
\code{\link{cff}} object. Must be \code{character} object indicating either:
\itemize{
\item The path to a BibTeX file.
\item A vector of characters with the full BibTeX string. See \strong{Examples}.
}}

\item{encoding}{Encoding to be assumed for \code{x}. See \code{\link[=readLines]{readLines()}}.}

\item{...}{Other arguments passed to \code{\link[bibtex:read.bib]{bibtex::read.bib()}}.}
}
\value{
See \code{\link[=cff_read_bib]{cff_read_bib()}} from reading \verb{*.bib} files and \code{\link[=cff_read_bib_text]{cff_read_bib_text()}}
for reading a \code{character} object representing a BibTeX entry.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use either \code{\link[=cff_read_bib]{cff_read_bib()}} or
\code{\link[=cff_read_bib_text]{cff_read_bib_text()}} instead.
}
\examples{
if (requireNamespace("bibtex", quietly = TRUE)) {
  x <- c(
    "@book{einstein1921,
    title        = {Relativity: The Special and the General Theory},
    author       = {Einstein, Albert},
    year         = 1920,
    publisher    = {Henry Holt and Company},
    address      = {London, United Kingdom},
    isbn         = 9781587340925
}",
    "@misc{misc-full,
    title        = {Handing out random pamphlets in airports},
    author       = {Joe-Bob Missilany},
    year         = 1984,
    month        = oct,
    note         = {This is a full MISC entry},
    howpublished = {Handed out at O'Hare}
}"
  )

  cff_read_bib_text(x)

  # From a file

  x2 <- system.file("examples/example.bib", package = "cffr")
  cff_read_bib(x2)
}
}
\seealso{
Other deprecated functions:
\code{\link{cff_extract_to_bibtex}()},
\code{\link{cff_parse_citation}()},
\code{\link{cff_parse_person}()},
\code{\link{write_bib}()}
}
\concept{deprecated}
\keyword{internal}
