% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{angleToPlane}
\alias{angleToPlane}
\title{Angle with a Reference Plane}
\usage{
angleToPlane(
  x,
  p1 = c(0, 0, 0),
  p2 = c(0, 1, 0),
  p3 = c(1, 0, 0),
  from = 1,
  xdiff = diff(x),
  degrees = TRUE
)
}
\arguments{
\item{x}{a single input track; a matrix whose first column is time and whose
remaining columns are a spatial coordinate.}

\item{p1, p2, p3}{numeric vectors of coordinates of three points specifying a reference plane to
compute distances to.}

\item{from}{index, or vector of indices, of the first row of the track. If
\code{from} is a vector, angles are returned for all steps starting at
the indices in \code{from}.}

\item{xdiff}{row differences of x.}

\item{degrees}{logical; should angles be returned in degrees rather than radians? (default = TRUE).}
}
\value{
A single angle.
}
\description{
Compute the angle between the first step of a track and a reference plane.
Useful to detect directed movement and/or tracking artefacts.
}
\details{
The average angle of steps to a reference plane should be roughly 32.7 degrees.
 Lower angles to the border planes of an imaging volume can be indicative of tracking
 artefacts, and systematic deviations from 32.7 can indicate a directional bias
 (Beltman et al, 2009).
}
\examples{
## Plotting the angle versus the distance to a reference plane can be informative to
## detect tracking artefacts near the border of the imaging volume.
## We should be suspicious especially when small angles are more frequent at low distances
## to the border planes.
steps <- subtracks( TCells, 1 )
minz <- boundingBox( TCells )["min","z"]
## Compute angles and distances to the lower plane in z-dimension
angles <- sapply( steps, angleToPlane, p1 = c(0,0,minz), p2 = c(1,0,minz), p3 = c(0,1,minz) )
distances <- sapply( steps, distanceToPlane, p1 = c(0,0,minz), p2 = c(1,0,minz), p3 = c(0,1,minz) )
scatter.smooth( distances, angles )
abline( h = 32.7, col = "red" )
}
\references{
Joost B. Beltman, Athanasius F.M. Maree and Rob. J. de Boer (2009),
Analysing immune cell migration. \emph{Nature Reviews Immunology} \bold{9},
789--798. doi:10.1038/nri2638
}
\seealso{
\code{\link{distanceToPlane}} to compute the distance to the reference plane, and
 \code{\link{AngleAnalysis}} for other methods to compute angles and distances.
}
