% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_plot.R
\name{rate_plot}
\alias{rate_plot}
\title{Rate plot}
\usage{
rate_plot(
  seahorse_rates,
  measure = "OCR",
  assay = "MITO",
  error_bar = "ci",
  conf_int = 0.95,
  group_label = "Experimental group"
)
}
\arguments{
\item{seahorse_rates}{data.table Seahorse OCR and ECAR rates (imported using \code{read_data} function)}

\item{measure}{Whether to plot \code{"OCR"} or \code{"ECAR"}}

\item{assay}{What assay to plot (e.g. "MITO" or "GLYCO")}

\item{error_bar}{Whether to plot error bars as standard deviation (\code{"sd"}) or confidence intervals (\code{"ci"})}

\item{conf_int}{The confidence interval percentage. Should be between 0 and 1}

\item{group_label}{Label for the experimental group to populate the legend title}
}
\value{
a ggplot
}
\description{
Generate OCR and ECAR plots
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
rate_plot(seahorse_rates, measure = "OCR", error_bar = "ci", conf_int = 0.95)
}
