% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aipwee_est.R
\name{aipwee_est}
\alias{aipwee_est}
\title{Prediction with a residual bias correction estimator}
\usage{
aipwee_est(Y,
           treat,
           covar_formula = ~ 1,
           covar_lin_formula = ~ 1,
           covar_sq_formula = ~ 1,
           data,
           e_treat_1 = NULL,
           e_treat_2 = NULL,
           e_treat_3 = NULL,
           e_treat_4 = NULL,
           degree = 1,
           wt = NULL,
           method = "same",
           spline_df = NULL,
           spline_const = 1,
           spline_linear = 1,
           spline_quad = 1)
}
\arguments{
\item{Y}{is the the name of the outcome variable contained in \code{data}.}

\item{treat}{is the name of the treatment variable contained in
\code{data}.}

\item{covar_formula}{is the formula to describe the covariates needed
to estimate the constant term:
\code{~ X.1 + ....}. Can include higher order terms or interactions.  i.e.
\code{~ X.1 + I(X.1^2) + X.1 * X.2 + ....}.  Don't forget the tilde before
listing the covariates.}

\item{covar_lin_formula}{is the formula to describe the covariates needed
to estimate the linear term, t:
\code{~ X.1 + ....}. Can include higher order terms or interactions.  i.e.
\code{~ X.1 + I(X.1^2) + X.1 * X.2 + ....}.  Don't forget the tilde before
listing the covariates.}

\item{covar_sq_formula}{is the formula to describe the covariates needed
to estimate the quadratic term, t^2:
\code{~ X.1 + ....}. Can include higher order terms or interactions.  i.e.
\code{~ X.1 + I(X.1^2) + X.1 * X.2 + ....}.  Don't forget the tilde before
listing the covariates.}

\item{data}{is a dataframe containing \code{Y}, \code{treat}, and
\code{X}.}

\item{e_treat_1}{a vector, representing the conditional expectation of
\code{treat} from \code{T_mod}.}

\item{e_treat_2}{a vector, representing the conditional expectation of
\code{treat^2} from \code{T_mod}.}

\item{e_treat_3}{a vector, representing the conditional expectation of
\code{treat^3} from \code{T_mod}.}

\item{e_treat_4}{a vector, representing the conditional expectation of
\code{treat^4} from \code{T_mod}.}

\item{degree}{is 1 for linear and 2 for quadratic outcome model.}

\item{wt}{is weight used in lsfit for outcome regression.
Default is wt = NULL.}

\item{method}{is "same" if the same set of covariates are used to estimate
the constant, linear, and/or quadratic term.  If method = "different", then
different sets of covariates can be used to estimate the constant, linear,
and/or quadratic term.  covar_lin_formula and covar_sq_formula must be specified
if method = "different".}

\item{spline_df}{degrees of freedom. The default, spline_df = NULL, corresponds to no knots.}

\item{spline_const}{is the number of spline terms needed to estimate the constant term.}

\item{spline_linear}{is the number of spline terms needed to estimate the linear term.}

\item{spline_quad}{is the number of spline terms needed to estimate the quadratic term.}
}
\value{
\code{aipwee_est}  returns an object of class "causaldrf_lsfit",
a list that contains the following components:
\item{param}{parameter estimates for a add_spl fit.}
\item{t_mod}{the result of the treatment model fit.}
\item{out_mod}{the result of the outcome model fit.}
\item{call}{the matched call.}
}
\description{
This method combines the regression estimator with a residual bias correction
for estimating a parametric ADRF.
}
\examples{
## Example from Schafer (2015).

example_data <- sim_data


t_mod_list <- t_mod(treat = T,
              treat_formula = T ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
              data = example_data,
              treat_mod = "Normal")

cond_exp_data <- t_mod_list$T_data
full_data <- cbind(example_data, cond_exp_data)

aipwee_list <- aipwee_est(Y = Y,
                         treat = T,
                         covar_formula = ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
                         covar_lin_formula = ~ 1,
                         covar_sq_formula = ~ 1,
                         data = example_data,
                         e_treat_1 = full_data$est_treat,
                         e_treat_2 = full_data$est_treat_sq,
                         e_treat_3 = full_data$est_treat_cube,
                         e_treat_4 = full_data$est_treat_quartic,
                         degree = 1,
                         wt = NULL,
                         method = "same",
                         spline_df = NULL,
                         spline_const = 1,
                         spline_linear = 1,
                         spline_quad = 1)

sample_index <- sample(1:1000, 100)

plot(example_data$T[sample_index],
      example_data$Y[sample_index],
      xlab = "T",
      ylab = "Y",
      main = "aipwee estimate")

abline(aipwee_list$param[1],
        aipwee_list$param[2],
        lty = 2,
        lwd = 2,
        col = "blue")

legend('bottomright',
        "aipwee estimate",
        lty = 2,
        lwd = 2,
        col = "blue",
        bty='Y',
        cex=1)

rm(example_data, t_mod_list, cond_exp_data, full_data, aipwee_list, sample_index)
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.
}
\seealso{
\code{\link{iptw_est}}, \code{\link{ismw_est}},
 \code{\link{reg_est}}, \code{\link{wtrg_est}},
  ##'    etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

