% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{cps_mixtape}
\alias{cps_mixtape}
\title{Observational counterpart to nsw_mixtape data}
\format{
A data frame with 15992 rows and 11 variables
\describe{
\item{data_id}{Individual ID}
\item{treat}{In the National Supported Work Demonstration Job Training Program}
\item{age}{Age in years}
\item{educ}{Years of education}
\item{black}{Race: Black}
\item{hisp}{Ethnicity: Hispanic}
\item{marr}{Married}
\item{nodegree}{Has no degree}
\item{re74}{Real earnings 1974}
\item{re75}{Real earnings 1975}
\item{re78}{Real earnings 1978}
}
}
\source{
Dehejia, Rajeev H., and Sadek Wahba. 1999. “Causal Effects in Nonexperimental Studies: Reevaluating the Evaluation of Training Programs.” Journal of the American Statistical Association 94 (448): 1053–62.".
}
\usage{
cps_mixtape
}
\description{
Data from the Current Population Survey on participation in the National Supported Work Demonstration (NSW) job-training program experiment. This is used as an observational comparison to the NSW experimental data from the nsw_mixtape data.
}
\details{
This data is used in the \emph{Matching and Subclassification} chapter of \emph{Causal Inference: The Mixtape} by Cunningham.
}
\references{
Cunningham. 2021. Causal Inference: The Mixtape. Yale Press. \url{https://mixtape.scunning.com/index.html}.
}
\keyword{datasets}
