% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{mcnemarQ}
\alias{mcnemarQ}
\title{McNemar's test}
\usage{
mcnemarQ(X, na.rm = TRUE, quiet = FALSE, digits = getOption("digits"))
}
\arguments{
\item{X}{matrix of \code{I} assessors (rows) and \code{J} products (columns)
where values are \code{0} (not checked) or \code{1} (checked)}

\item{na.rm}{should \code{NA} values be removed?}

\item{quiet}{if \code{FALSE} (default) then it prints information related to 
the test; if \code{TRUE} it returns only the test statistic (\code{Q})}

\item{digits}{significant digits (to display)}
}
\value{
Test results for all McNemar pairwise tests conducted via the 
binomial test
}
\description{
Pairwise tests are conducted using the two-tailed binomial test. These tests
can be conducted after Cochran's Q test.
}
\examples{
data(bread)

# McNemar's exact pairwise test for all product pairs
# on the first 40 consumers and the first attribute ("Fresh")
mcnemarQ(bread$cata[1:40,,1])
}
\references{
Cochran, W. G. (1950). The comparison of percentages in matched samples. 
\emph{Biometrika}, 37, 256-266. 

McNemar, Q. (1947). Note on the sampling error of the difference between 
correlated proportions or percentages. \emph{Psychometrika}, 12(2), 153-157.

Meyners, M., Castura, J.C., & Carr, B.T. (2013). Existing and  
new approaches for the analysis of CATA data. \emph{Food Quality and 
Preference}, 30, 309-319, \doi{10.1016/j.foodqual.2013.06.010}
}
\seealso{
\code{\link[cata]{cochranQ}}
}
