% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cargo.R
\name{run}
\alias{run}
\title{Run Cargo}
\usage{
run(..., verbose = TRUE)
}
\arguments{
\item{...}{Arguments passed to \code{\link{system2}}, although the
\code{command} argument is set to \code{cargo} by this function and cannot
be set by the user.}

\item{verbose}{Should debugging information be written to the console before
running Cargo?}
}
\value{
The result of the underlying call to the \code{system2} function used
to run Cargo is returned or, if Cargo is not found, an error is thrown.
}
\description{
This function finds and invokes Cargo (Rust's package manager) with
\code{...} arguments passed to \code{\link[=system2]{system2()}} but, by default, does not write to
the user's file system (e.g., \code{~/.cargo}) to comply with CRAN policies.
}
\details{
To enable caching, set the \code{R_CARGO_SAVE_CACHE} environment variable to
\code{TRUE}. Then, if defined, the \code{R_CARGO_HOME} environment variable
will be used as the cache location. Otherwise, Cargo uses its default
behavior (usually writing to \code{~/.cargo} unless the \code{CARGO_HOME}
environment variable is set). Regardless of the location, the user is
responsible to maintaining and clearing the cache when using the
\code{R_CARGO_SAVE_CACHE} environment variable.
}
\examples{
if ( is_available() ) {
  run("--version")
  run("--help")
}

}
\seealso{
\code{\link[base:system2]{base::system2()}}, \code{\link[base:Sys.setenv]{base::Sys.setenv()}}
}
