% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evenodd.R
\name{evenodd}
\alias{evenodd}
\title{Calculates the even-odd consistency score}
\usage{
evenodd(x, factors, diag = FALSE)
}
\arguments{
\item{x}{a matrix of data (e.g. survey responses)}

\item{factors}{a vector of integers specifying the length of each
factor in the dataset}

\item{diag}{optionally returns a column with the number of available (i.e., non-missing) even/odd pairs per observation.
Useful for datasets with many missing values.}
}
\description{
Takes a matrix of item responses and a vector of integers representing the
length each factor. The even-odd consistency score is then computed as the
within-person correlation between the even and odd subscales over all the
factors.
}
\examples{
careless_eo <- evenodd(careless_dataset, rep(5,10))
careless_eodiag <- evenodd(careless_dataset, rep(5,10), diag = TRUE)
}
\references{
Johnson, J. A. (2005). Ascertaining the validity of individual protocols
from web-based personality inventories. \emph{Journal of Research in Personality, 39}, 103-129. \doi{10.1016/j.jrp.2004.09.009}
}
\author{
Richard Yentes \email{rdyentes@ncsu.edu}, Francisco Wilhelm \email{franciscowilhelm@gmail.com}
}
