% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/area_simulate.R
\name{sim_area_single_concept_with_risk}
\alias{sim_area_single_concept_with_risk}
\title{sim_area_single_concept_with_risk}
\usage{
sim_area_single_concept_with_risk(
  state_vars,
  parms,
  event_times,
  time_span = 100L,
  time_frac = 4L,
  integ_method = "lsoda"
)
}
\arguments{
\item{state_vars}{list of state variable(s) (vectors), all initialized}

\item{parms}{list of parameter(s) (vectors)}

\item{event_times}{vector of integers specifying the points in time when
damage events can happen. Usually all numbers between (and including) zero
and the endpoint of the simulation (i.e. \code{c(0, time_span)}).}

\item{time_span}{simulation time span, integer, in the chosen time unit
(typically years)}

\item{time_frac}{integer >= 1, defines the time step to be used for numerical
integration (time step = 1 / time_frac), i.e. one time unit will be split
into time_frac substeps. Too small values of \code{time_frac} may cause the
model showing chaotic dynamics, too large values increase computation time
without meaningful gains in precision. The default value of 4 is mostly a
good choice; in doubt, increase \code{time_frac} until the results do not
change meaningfully anymore (risk events should be turned off during that
procedure).}

\item{integ_method}{integration method, passed to \code{\link[deSolve]{ode}}}
}
\value{
an object of class \code{deSolve}
}
\description{
Low-level simulation function for area-phase dynamics, available for users
who want to compose simulations out of the single steps. Regular users are
recommended to use the function \code{\link{simulate_single_concept}}.
}
\examples{
  # Work with the example data pine_thinning_from_above_1
  # Initialize state variables (areas per stand development phase)
  state_vars <- setup_statevars(pine_thinning_from_above_1,
                                c(1000, 0, 0, 0, 0, 0))

  # Set time frame
  time_span          <- 200

  # Initialize parameters
  parms     <- setup_parms(pine_thinning_from_above_1)

  # Build risk matrix and add it to parms
  parms$risk_mat <- setup_risk_events(
    time_span, avg_event_strength = 1, parms$risk
  )

  # Simulate
  sim_area_single_concept_with_risk(
    state_vars,
    parms       = parms,
    event_times = c(0:time_span),
    time_span   = time_span
  )

}
