% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_missing.survey.design.R
\name{ard_missing.survey.design}
\alias{ard_missing.survey.design}
\title{ARD Missing Survey Statistics}
\usage{
\method{ard_missing}{survey.design}(
  data,
  variables,
  by = NULL,
  statistic = everything() ~ c("N_obs", "N_miss", "N_nonmiss", "p_miss", "p_nonmiss",
    "N_obs_unweighted", "N_miss_unweighted", "N_nonmiss_unweighted", "p_miss_unweighted",
    "p_nonmiss_unweighted"),
  fmt_fn = NULL,
  stat_label = everything() ~ list(N_obs = "Total N", N_miss = "N Missing", N_nonmiss =
    "N not Missing", p_miss = "\% Missing", p_nonmiss = "\% not Missing",
    N_obs_unweighted = "Total N (unweighted)", N_miss_unweighted =
    "N Missing (unweighted)", N_nonmiss_unweighted = "N not Missing (unweighted)",
    p_miss_unweighted = "\% Missing (unweighted)", p_nonmiss_unweighted =
    "\% not Missing (unweighted)"),
  ...
)
}
\arguments{
\item{data}{(\code{survey.design})\cr
a design object often created with \code{\link[survey:svydesign]{survey::svydesign()}}.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
results are calculated for \strong{all combinations} of the column specified
and the variables. A single column may be specified.}

\item{statistic}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a character vector of
statistic names to include. See default value for options.}

\item{fmt_fn}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) round(x, digits = 2) |> as.character()))}.}

\item{stat_label}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where
the list element is either a named list or a list of formulas defining the
statistic labels, e.g. \code{everything() ~ list(mean = "Mean", sd = "SD")} or
\code{everything() ~ list(mean ~ "Mean", sd ~ "SD")}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Compute Analysis Results Data (ARD) for statistics related to data missingness for survey objects
}
\examples{
\dontshow{if (cardx:::is_pkg_installed("survey")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
svy_titanic <- survey::svydesign(~1, data = as.data.frame(Titanic), weights = ~Freq)

ard_missing(svy_titanic, variables = c(Class, Age), by = Survived)
\dontshow{\}) # examplesIf}
}
