% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_population.R
\name{read_population}
\alias{read_population}
\title{Reads in data in the R/qtl csv format}
\usage{
read_population(
  filename = NULL,
  pheno_col = NULL,
  geno_col = NULL,
  id_col = NULL,
  delim = ",",
  na_strings = "-",
  check_chr_order = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{filename}{The name of the file to read in}

\item{pheno_col}{Column numbers of desired traits. The default
behavior is to read in all traits.}

\item{geno_col}{Column numbers of desired markers. The default
behavior is to read in all markers.}

\item{id_col}{The column number of an ID column. This is helpful to
specify if the individual IDs are strings. Strings are only
allowed in the ID column. All other trait data must be numeric.}

\item{delim}{column delimiter for the file, default is ","}

\item{na_strings}{a character string indicating how NA values are specified, default is "-"}

\item{check_chr_order}{boolean, default is TRUE}

\item{verbose}{A  logical value indicating whether to print progress 
and cross information to the screen. Defaults to TRUE.}
}
\value{
This function returns a cape object in a former cape format.
It must be updated using \code{\link{cape2mpp}}
}
\description{
This function reads in a data file in the r/qtl format
It converts letter genotypes to numbers if required.
It parses the data into a data object.
if filename is left empty, the script will ask the
use to choose a file.
phenotypes can be specified with a vector of column 
numbers or character strings. For each phenotype
specified with a name, the script will find its location.
}
\examples{
\dontrun{
cape_obj <- read_population("cross.csv")
combined_obj <- cape2mpp(cape_obj)
data_obj <- combined_obj$data_obj
geno_obj <- combined_obj$geno_obj
}

}
\references{
Broman et al. (2003) R/qtl: QTL mapping in experimental crosses. 
Bioinformatics 19:889-890 doi:10.1093/bioinformatics/btg112
}
