% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_vectors.R
\name{get_cansim_vector}
\alias{get_cansim_vector}
\title{Retrieve data for a Statistics Canada data vector released within a given time frame}
\usage{
get_cansim_vector(vectors, start_time, end_time = Sys.Date(),
  use_ref_date = TRUE)
}
\arguments{
\item{vectors}{The list of vectors to retrieve}

\item{start_time}{Starting date in \code{YYYY-MM-DD} format, applies to \code{REF_DATE} or \code{releaseTime}, depending on \code{use_ref_date} parameter}

\item{end_time}{Set an optional end time filter in \code{YYYY-MM-DD} format (defaults to current system time)}

\item{use_ref_date}{Optional, \code{TRUE} by default. When set to \code{TRUE}, uses \code{REF_DATE} of vector data to filter, otherwise it uses Statistics Canada's \code{releaseDate} value for filtering the specified vectors}
}
\value{
A tibble with data for vectors released between start and end time
}
\description{
Retrieve data for a Statistics Canada data vector released within a given time frame
}
