% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_camtrapdp.R
\name{read_camtrapdp}
\alias{read_camtrapdp}
\title{Read a Camera Trap Data Package}
\usage{
read_camtrapdp(file)
}
\arguments{
\item{file}{Path or URL to a \code{datapackage.json} file.}
}
\value{
Camera Trap Data Package object.
}
\description{
Reads files from a \href{https://camtrap-dp.tdwg.org}{Camera Trap Data Package (Camtrap DP)} into memory.
}
\section{Assign taxonomic information}{


Camtrap DP metadata has a \code{taxonomic} property that can contain extra
information for each \code{scientificName} found in observations.
Such information can include higher taxonomy (\code{family}, \code{order}, etc.) and
vernacular names in multiple languages.

This function \strong{will automatically include this taxonomic information in
observations}, as extra columns starting with \code{taxon.}.
}

\section{Assign eventIDs}{


Observations can contain two classifications at two levels:

\strong{Media-based} observations (\code{observationLevel = "media"}) are based on a
single media file and are directly linked to it via \code{mediaID}.

\strong{Event-based} observations (\code{observationLevel = "event"}) are based on an
event, defined as a combination of \code{eventID}, \code{eventStart} and \code{eventEnd}.
This event can consist of one or more media files, but is not directly linked
to these.

This function \strong{will automatically assign \code{eventID}s to media}, using
\code{media.deploymentID = event.deploymentID} and \verb{eventStart <= media.timestamp <= eventEnd}.
Note that this can result in media being linked to multiple events (and thus
being duplicated), for example when events and sub-events were defined.
}

\examples{
file <- "https://raw.githubusercontent.com/tdwg/camtrap-dp/1.0/example/datapackage.json"
x <- read_camtrapdp(file)
x
}
\concept{read functions}
