% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_xsq.R
\name{cluster_xsq}
\alias{cluster_xsq}
\title{Chi-Square Goodness-of-Fit Test}
\usage{
cluster_xsq(cacc_matrix)
}
\arguments{
\item{cacc_matrix}{A tibble. The output of the \code{cacc} function.}
}
\value{
Returns a list with the Chi-square results. This is the same object returned by the \code{chisq.test} function from the \code{stats} package.
}
\description{
Computes a Chi-Square Goodness-of-Fit Test to determine whether there is statistically significant clustering of observations among dominant profiles in a \code{cacc_matrix}.
}
\examples{
cluster_xsq(cacc(onharassment, ivs = sex:privacy, dv = rep_victim))
}
\references{
Hart, T. C. (2019). Identifying Situational Clustering and Quantifying Its Magnitude in Dominant Case Configurations: New Methods for Conjunctive Analysis. \emph{Crime & Delinquency, 66}(1), 143-159. https://doi.org/10.1177/0011128719866123
}
