% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinomial_reg-predict.R
\name{predict.brulee_multinomial_reg}
\alias{predict.brulee_multinomial_reg}
\title{Predict from a \code{brulee_multinomial_reg}}
\usage{
\method{predict}{brulee_multinomial_reg}(object, new_data, type = NULL, epoch = NULL, ...)
}
\arguments{
\item{object}{A \code{brulee_multinomial_reg} object.}

\item{new_data}{A data frame or matrix of new predictors.}

\item{type}{A single character. The type of predictions to generate.
Valid options are:
\itemize{
\item \code{"class"} for hard class predictions
\item \code{"prob"} for soft class predictions (i.e., class probabilities)
}}

\item{epoch}{An integer for the epoch to make predictions. If this value
is larger than the maximum number that was fit, a warning is issued and the
parameters from the last epoch are used. If left \code{NULL}, the epoch
associated with the smallest loss is used.}

\item{...}{Not used, but required for extensibility.}
}
\value{
A tibble of predictions. The number of rows in the tibble is guaranteed
to be the same as the number of rows in \code{new_data}.
}
\description{
Predict from a \code{brulee_multinomial_reg}
}
\examples{
if (torch::torch_is_installed()) {

  library(recipes)
  library(yardstick)

  data(penguins, package = "modeldata")

  penguins <- penguins \%>\% na.omit()

  set.seed(122)
  in_train <- sample(1:nrow(penguins), 200)
  penguins_train <- penguins[ in_train,]
  penguins_test  <- penguins[-in_train,]

  rec <- recipe(island ~ ., data = penguins_train) \%>\%
    step_dummy(species, sex) \%>\%
    step_normalize(all_numeric_predictors())

  set.seed(3)
  fit <- brulee_multinomial_reg(rec, data = penguins_train, epochs = 5)
  fit

  predict(fit, penguins_test) \%>\%
    bind_cols(penguins_test) \%>\%
    conf_mat(island, .pred_class)
}
}
