% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{db_jobs_list}
\alias{db_jobs_list}
\title{List Jobs}
\usage{
db_jobs_list(
  limit = 25,
  offset = 0,
  expand_tasks = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{limit}{Number of jobs to return. This value must be greater than 0 and
less or equal to 25. The default value is 25. If a request specifies a limit
of 0, the service instead uses the maximum limit.}

\item{offset}{The offset of the first job to return, relative to the most
recently created job.}

\item{expand_tasks}{Whether to include task and cluster details in the
response.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
List Jobs
}
\seealso{
Other Jobs API: 
\code{\link{db_jobs_create}()},
\code{\link{db_jobs_delete}()},
\code{\link{db_jobs_get}()},
\code{\link{db_jobs_reset}()},
\code{\link{db_jobs_run_now}()},
\code{\link{db_jobs_runs_cancel}()},
\code{\link{db_jobs_runs_delete}()},
\code{\link{db_jobs_runs_export}()},
\code{\link{db_jobs_runs_get}()},
\code{\link{db_jobs_runs_get_output}()},
\code{\link{db_jobs_runs_list}()},
\code{\link{db_jobs_runs_submit}()},
\code{\link{db_jobs_update}()}
}
\concept{Jobs API}
