% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{coef_circ.bpnme}
\alias{coef_circ.bpnme}
\title{Obtain the circular coefficients of a Bayesian circular mixed-effects model}
\usage{
\method{coef_circ}{bpnme}(object, type = "continuous",
  units = "radians")
}
\arguments{
\item{object}{a \code{bpnme object} obtained from the function
\code{\link{bpnme}}}

\item{type}{one of \code{c("continuous", "categorical")} to get either the
coefficients for the continuous or categorical predictor variables}

\item{units}{one of \code{c("degrees", "radians")} to get categorical
coefficients estimates and estimates for \code{$a_c$} in degrees or
radians.}
}
\value{
A matrix or list with posterior summaries of the circular
  coefficients in a Bayesian circular mixed-effects model.
}
\description{
Gives the coefficients tables of the circular coefficients for a Bayesian
circular mixed-effects model.
}
\examples{
library(bpnreg)
fit.Maps <- bpnme(pred.I = Error.rad ~ Maze + Trial.type + L.c + (1|Subject),
data = Maps,
its = 100, burn = 1, n.lag = 1)
coef_circ(fit.Maps)

}
