% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-pairs.R
\name{blr_pairs}
\alias{blr_pairs}
\title{Concordant & discordant pairs}
\usage{
blr_pairs(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
A tibble.
}
\description{
Association of predicted probabilities and observed responses.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_pairs(model)

}
\references{
Nelsen  RB  (1998):  Concordance  and  Gini’s  measure  of  association. Journal  of  Nonparametric  
Statistics, 9(3):227–238. 

Newson  R  (2006):  Confidence  intervals  for  rank  statistics:  Somers'  D  and  extensions.  
The  Stata Journal, 6(3):309–334.
}
\seealso{
Other model fit statistics: \code{\link{blr_model_fit_stats}},
  \code{\link{blr_multi_model_fit_stats}},
  \code{\link{blr_rsq_adj_count}},
  \code{\link{blr_rsq_cox_snell}},
  \code{\link{blr_rsq_effron}},
  \code{\link{blr_rsq_mcfadden_adj}},
  \code{\link{blr_rsq_mckelvey_zavoina}},
  \code{\link{blr_rsq_nagelkerke}},
  \code{\link{blr_test_lr}}
}
