% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebGibbsSampler.R
\name{rl.gibbs}
\alias{rl.gibbs}
\title{Gibbs sampler for empirically motivated Bayesian record linkage}
\usage{
rl.gibbs(file.num = file.num, X.s = X.s, X.c = X.c, num.gs = num.gs,
  a = a, b = b, c = c, d = d, M = M)
}
\arguments{
\item{file.num}{The number of the file}

\item{X.s}{A vector of string variables}

\item{X.c}{A vector of categorical variables}

\item{num.gs}{Total number of gibb iterations}

\item{a}{Shape parameter of Beta prior}

\item{b}{Scale parameter of Beta prior}

\item{c}{Positive constant}

\item{d}{Any distance metric measuring the latent and observed string}

\item{M}{The true value of the population size}
}
\value{
lambda.out The estimated linkage structure via Gibbs sampling
}
\description{
Gibbs sampler for empirically motivated Bayesian record linkage
}
\examples{
data(RLdata500)
X.c <- as.matrix(RLdata500[c("by","bm","bd")])[1:3,]
p.c <- ncol(X.c)
X.s <- as.matrix(RLdata500[c(1,3)])[1:3,]
p.s <- ncol(X.s)
file.num <- rep(c(1,1,1),c(1,1,1))
d <- function(string1,string2){adist(string1,string2)}
lam.gs <- rl.gibbs(file.num,X.s,X.c,num.gs=2,a=.01,b=100,c=1,d, M=3)
}
