% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeGibbs.R
\name{links.compare}
\alias{links.compare}
\title{This function takes a set of pairwise links and identifies correct, incorrect,
and missing links
(correct = estimated and true, incorrect = estimated but not true,
missing = true but not estimated)}
\usage{
links.compare(est.links.pair, true.links.pair, counts.only = TRUE)
}
\arguments{
\item{est.links.pair}{The number of estimated links}

\item{true.links.pair}{The number of true links}

\item{counts.only}{State whether or not counts only is true or false}
}
\value{
Gives a vector of the estimated and true links, estimated but not true links, and the true but not estimated links
}
\description{
This function takes a set of pairwise links and identifies correct, incorrect,
and missing links
(correct = estimated and true, incorrect = estimated but not true,
missing = true but not estimated)
}
\examples{
id <- c(1,2,3,4,5,1,7,8,9,10,11,12,13,14,15,16,17,18,19,20)
lam.gs <- matrix(c(1,1,2,2,3,3,5,6,4,3,4,5,3,2,4,1,2,3,4,2),ncol=20, nrow=4)
est.links <- links(lam.gs)
true.links <- links(matrix(id,nrow=1))
links.compare(est.links, true.links=id)
}
