% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtc.sig.R
\name{wtc.sig}
\alias{wtc.sig}
\title{Determine significance of wavelet coherence}
\usage{
wtc.sig(nrands = 300, lag1, dt, ntimesteps, pad = TRUE, dj = 1/12,
  s0, J1, max.scale = NULL, mother = "morlet", sig.level = 0.95,
  quiet = FALSE)
}
\arguments{
\item{nrands}{Number of Monte Carlo randomizations.}

\item{lag1}{Vector containing the AR(1) coefficient of each time series.}

\item{dt}{Length of a time step.}

\item{ntimesteps}{Number of time steps in time series.}

\item{pad}{Pad the values will with zeros to increase the speed of the
transform.}

\item{dj}{Spacing between successive scales.}

\item{s0}{Smallest scale of the wavelet.}

\item{J1}{Number of scales - 1.}

\item{max.scale}{Maximum scale.}

\item{mother}{Type of mother wavelet function to use. Can be set to
\code{morlet}, \code{dog}, or \code{paul}.
Significance testing is only available for \code{morlet} wavelet.}

\item{sig.level}{Significance level to compute.}

\item{quiet}{Do not display progress bar.}
}
\value{
Returns significance matrix containing the \code{sig.level}
  percentile of wavelet coherence at each time step and scale.
}
\description{
Determine significance of wavelet coherence
}
\note{
The Monte Carlo randomizations can be extremely slow for large
  datasets. For instance, 1000 randomizations of a dataset consisting of 1000
  samples will take ~30 minutes on a 2.66 GHz dual-core Xeon processor.
}
\examples{
# Not run: wtcsig <- wtc.sig(nrands, lag1 = c(d1.ar1, d2.ar1), dt,
#                            pad, dj, J1, s0, mother = "morlet")

}
\references{
Cazelles, B., M. Chavez, D. Berteaux, F. Menard, J. O. Vik, S. Jenouvrier,
and N. C. Stenseth. 2008. Wavelet analysis of ecological time series.
\emph{Oecologia} 156:287-304.

Grinsted, A., J. C. Moore, and S. Jevrejeva. 2004. Application of the cross
wavelet transform and wavelet coherence to geophysical time series.
\emph{Nonlinear Processes in Geophysics} 11:561-566.

Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis.
\emph{Bulletin of the American Meteorological Society} 79:61-78.

Torrence, C., and P. J. Webster. 1998. The annual cycle of persistence in the
El Nino/Southern Oscillation. \emph{Quarterly Journal of the Royal
Meteorological Society} 124:1985-2004.
}
\author{
Tarik C. Gouhier (tarik.gouhier@gmail.com)

Code based on WTC MATLAB package written by Aslak Grinsted.
}
